using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for DataGridWeakD.
	/// </summary>
	public class DataGridWeakD : GUI.controls.BaseControl
	{
		#region Variables

		private Hashtable resultLookup;
		private System.Data.DataTable _dataTable;

		#endregion


		#region Controls

		private System.Windows.Forms.DataGridTableStyle _dgTableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgWeakD;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Button btnClear;
		private System.ComponentModel.IContainer components;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DataGridWeakD()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			InitializeGrid();

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion


		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DataGridWeakD));
			this.dgWeakD = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnClear = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.dgWeakD)).BeginInit();
			this.SuspendLayout();
			// 
			// dgWeakD
			// 
			this.dgWeakD.AllowSorting = false;
			this.dgWeakD.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.dgWeakD.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgWeakD.CaptionText = "Patient Weak D";
			this.dgWeakD.CaptionVisible = false;
			this.dgWeakD.DataMember = string.Empty;
			this.dgWeakD.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgWeakD.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgWeakD.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgWeakD.Name = "dgWeakD";
			this.dgWeakD.RowHeadersVisible = false;
			this.dgWeakD.Size = new System.Drawing.Size(492, 96);
			this.dgWeakD.TabIndex = 43;
			this.dgWeakD.ToolTipColumn = -1;
			// 
			// btnClear
			// 
			this.btnClear.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnClear.Image = ((System.Drawing.Bitmap)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new System.Drawing.Point(470, 1);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new System.Drawing.Size(20, 20);
			this.btnClear.TabIndex = 44;
			this.toolTip1.SetToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearResults().ResString);
			// 
			// DataGridWeakD
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnClear,
																		  this.dgWeakD});
			this.Name = "DataGridWeakD";
			this.Size = new System.Drawing.Size(492, 96);
			((System.ComponentModel.ISupportInitialize)(this.dgWeakD)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion


		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		private void InitializeGrid()
		{
			this.dgWeakD.CaptionVisible = true;
			//
			InitializeLookup();
			CreateTestTable();
			AddCustomDataTableStyle();

			this.dgWeakD.DataSource = _dataTable.DefaultView;
	
			((DataView)dgWeakD.DataSource).AllowNew = false;
			((DataView)dgWeakD.DataSource).AllowDelete = false;
			//
			DataRow dr = this._dataTable.NewRow();
			dr[0] = string.Empty;
			this._dataTable.Rows.Add(dr);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the "Positive" and "Negative" values of each test result
			resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add(string.Empty, "X");
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("H", "P");
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");
			resultLookup.Add("P", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
			resultLookup.Add("N", "N");
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates the blood unit test data table. 
		/// </summary>
		private void CreateTestTable()
		{
			_dataTable = new System.Data.DataTable();

			_dataTable.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			_dataTable.Columns.Add(TABLE.ValidRhResult.AntiD, typeof(String));
			_dataTable.Columns.Add(ARTIFICIAL.AntiDCC, typeof(String));
			_dataTable.Columns.Add(ARTIFICIAL.ControlD, typeof(String));
			_dataTable.Columns.Add(ARTIFICIAL.ControlDCC, typeof(String));
			_dataTable.Columns.Add(ARTIFICIAL.WeakDInterp, typeof(String));			
			_dataTable.Columns.Add(ARTIFICIAL.WeakDComment, typeof(String));
			_dataTable.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			_dataTable.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(String));
			_dataTable.Columns.Add(TABLE.Patient.RowVersion, typeof(Byte[]));
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddCustomDataTableStyle()
		{
			_dgTableStyle = new DataGridTableStyle();

			_dgTableStyle.AllowSorting = false;
			_dgTableStyle.DataGrid = dgWeakD;

			_dgTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgTableStyle.MappingName = string.Empty;
			_dgTableStyle.RowHeadersVisible = false;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			// 
			// AntiD
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-D";
			_dcTextKeyTrapCol.MappingName = TABLE.ValidRhResult.AntiD;
			_dcTextKeyTrapCol.Width = 80;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			// 
			// AntiDCC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Anti-D CC";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AntiDCC;
			_dcTextKeyTrapCol.Width = 80;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			// 
			// ControlD
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "D Control";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ControlD;
			_dcTextKeyTrapCol.Width = 80;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			// 
			// ControlDCC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "D Control CC";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.ControlDCC;
			_dcTextKeyTrapCol.Width = 80;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			// 
			// WeakDInterp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Weak D Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.WeakDInterp;
			_dcTextKeyTrapCol.Width = 80;
			_dcTextKeyTrapCol.ProcessAcross = true;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			// 
			// WeakDComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Weak D Comments";
			_dcTextBox.MappingName = ARTIFICIAL.WeakDComment;
			_dcTextBox.Width = 110;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			dgWeakD.TableStyles.Add(_dgTableStyle);				
		}

		#endregion

		#region Control Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		#endregion


	}
}
